/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.gui;

import com.opencsv.CSVReader;
import com.opencsv.CSVWriter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import jgamebase.Const;
import jgamebase.JGameBase;
import jgamebase.db.Db;
import jgamebase.db.Export;
import jgamebase.db.Import;
import jgamebase.db.Table;
import jgamebase.db.model.Extra;
import jgamebase.db.model.Game;
import jgamebase.db.model.Item;
import jgamebase.db.model.ItemView;
import jgamebase.db.model.ItemViewFilter;
import jgamebase.db.model.Music;
import jgamebase.db.model.Musician;
import jgamebase.gui.AboutDialog;
import jgamebase.gui.ClearGameLinkDialog;
import jgamebase.gui.ExtrasDialog;
import jgamebase.gui.GameChooserDialog;
import jgamebase.gui.GameInfoDialog;
import jgamebase.gui.Gui;
import jgamebase.gui.GuiObjects;
import jgamebase.gui.ItemTableModel;
import jgamebase.gui.ManageEmulatorsDialog;
import jgamebase.gui.MusicChooserDialog;
import jgamebase.gui.MusicInfoDialog;
import jgamebase.gui.MusicianDialog;
import jgamebase.gui.OptionsDialog;
import jgamebase.gui.PersonalInfoDialog;
import jgamebase.gui.ScreenshotChooserDialog;
import jgamebase.gui.SetGameLinkDialog;
import jgamebase.gui.UrlDialog;
import jgamebase.gui.VerifyAvailableFilesDialog;
import jgamebase.gui.VersionInfoDialog;
import jgamebase.gui.ViewDialog;
import jgamebase.gui.widgets.CompoundIcon;
import jgamebase.gui.widgets.JLongSeparator;
import jgamebase.gui.widgets.JScalingAnimation;
import jgamebase.gui.widgets.JScalingIcon;
import jgamebase.gui.widgets.JScalingImage;
import jgamebase.gui.widgets.JTitledSeparator;
import jgamebase.gui.widgets.JZoomableScalingImage;
import jgamebase.gui.widgets.flushable;
import jgamebase.model.Databases;
import jgamebase.model.Emulator;
import jgamebase.model.Emulators;
import jgamebase.model.FileExtensions;
import jgamebase.model.Paths;
import jgamebase.model.Plugins;
import jgamebase.plugins.DiskInfo;
import jgamebase.plugins.Extractor;
import jgamebase.plugins.MusicInfo;
import jgamebase.tools.DownloadTools;
import jgamebase.tools.FileTools;
import jgamebase.tools.StringTools;
import jgamebase.tools.SystemTools;
import jgamebase.tools.TempDir;
import org.apache.commons.collections4.map.MultiValueMap;

public abstract class GuiMethods
extends GuiObjects {
    private static final long serialVersionUID = -4564734022002580425L;
    protected int currentTab = 0;
    protected Item lastItem = null;
    protected int numExtraImagesShown;
    protected List<JScalingImage> gameImages = null;
    protected List<JScalingImage> additionalImages = null;
    protected List<Item> recent = new ArrayList<Item>();
    protected String find = "";
    protected Game linkGame = null;
    protected Extra copyExtra = null;
    Rectangle itemTableSavedPosition_Rect;
    int itemTableSavedPosition_Row;
    private final FileFilter csvFileFilter = new FileNameExtensionFilter("Comma Sepparated Values (*.csv)", "csv");
    private final FileFilter zipFileFilter = new FileNameExtensionFilter("Zip compressed game database (*.zip)", "zip");

    private List<Extra> filterExtrasByCategory(List<Extra> allExtras, Extra.Category category) {
        ArrayList<Extra> extras = new ArrayList<Extra>();
        extras.addAll(allExtras.stream().filter(extra -> extra.getCategory() == category).collect(Collectors.toList()));
        return extras;
    }

    private int countImagesForExtras(List<Extra> extras) {
        int count = 0;
        for (Extra extra : extras) {
            if (!extra.isImage() && !extra.isAnimation()) continue;
            ++count;
        }
        return count;
    }

    private void addAnimationsForExtrasToSideBar(JPanel panel, String title, List<Extra> extras) {
        if (this.countImagesForExtras(extras) > 0) {
            boolean addedSomething = false;
            panel.add(new JTitledSeparator(title));
            for (Extra extra : extras) {
                String filename = Paths.getExtraPath().find(new File(extra.getFilename())) != null ? Paths.getExtraPath().find(new File(extra.getFilename())).getPath() : "";
                try {
                    if (filename.isEmpty() || !extra.isAnimation()) continue;
                    addedSomething = true;
                    panel.add(new JScalingAnimation(filename, "<html>" + extra.getName() + (Databases.getCurrent().getPreferences().is("extras_show_filenames") ? "<br>" + extra.getFilename() : "") + "</html>"));
                    panel.add(new JLongSeparator());
                }
                catch (Exception exception) {}
            }
            if (addedSomething) {
                panel.remove(panel.getComponentCount() - 1);
            }
        }
    }

    private void addImagesForExtrasToSideBar(JPanel panel, List<JScalingImage> images, String title, List<Extra> extras) {
        if (this.countImagesForExtras(extras) > 0) {
            boolean addedSomething = false;
            panel.add(new JTitledSeparator(title));
            for (Extra extra : extras) {
                String filename = Paths.getExtraPath().find(new File(extra.getFilename())) != null ? Paths.getExtraPath().find(new File(extra.getFilename())).getPath() : "";
                try {
                    if (filename.isEmpty() || !extra.isImage()) continue;
                    addedSomething = true;
                    boolean loadImageAutomatically = this.numExtraImagesShown < 4;
                    JZoomableScalingImage image = JZoomableScalingImage.createOrGet(filename);
                    String tooltip = "<html>" + extra.getName() + (Databases.getCurrent().getPreferences().is("extras_show_filenames") ? "<br>" + extra.getFilename() : "") + "<br><br>" + "<i>Left click</i> to open with external viewer specified in options<br>" + "<i>Right click</i> to open with internal viewer</html>";
                    image.setTooltip(tooltip);
                    if (loadImageAutomatically) {
                        image.startLoadingImage();
                    }
                    panel.add(image);
                    panel.add(new JLongSeparator());
                    if (!loadImageAutomatically) {
                        images.add(image);
                    }
                    ++this.numExtraImagesShown;
                }
                catch (Exception exception) {}
            }
            if (addedSomething) {
                panel.remove(panel.getComponentCount() - 1);
            }
        }
    }

    private void addButtonsForExtrasToSidebar(List<Extra> extras) {
        boolean addedSomething = false;
        if (extras.size() > 0) {
            for (Extra extra : extras) {
                if (!extra.isUrl() && (extra.isImage() || extra.isAnimation())) continue;
                Icon icon = extra.getCategory().getIcon();
                if (this.linkGame != null) {
                    List<Extra> linkExtras = this.linkGame.getExtras();
                    for (Extra linkExtra : linkExtras) {
                        if (!extra.isUrl() || !extra.getFilename().equalsIgnoreCase(linkExtra.getFilename())) continue;
                        icon = new CompoundIcon(CompoundIcon.Axis.Z_AXIS, 0, 1.0f, 0.0f, icon, Const.ICON_CATEGORY_OVERLAY_EQUAL);
                    }
                }
                if (extra.isAdditional()) {
                    icon = new CompoundIcon(CompoundIcon.Axis.Z_AXIS, 0, 0.0f, 1.0f, icon, Const.ICON_CATEGORY_OVERLAY_ADDITIONAL);
                }
                if (extra.isUrl()) {
                    try {
                        String hostname = new URI(extra.getFilename()).getHost().toLowerCase();
                        File iconFile = new File(new File(Databases.getCurrent().getPath(), "Gfx"), String.valueOf(hostname) + ".png");
                        icon = iconFile.exists() ? new CompoundIcon(CompoundIcon.Axis.Z_AXIS, 0, 1.0f, 1.0f, icon, new ImageIcon(iconFile.getAbsolutePath())) : ((iconFile = new File(new File(Const.GBDIR_RO, "Artwork/Category/overlay"), String.valueOf(hostname) + ".png")).exists() ? new CompoundIcon(CompoundIcon.Axis.Z_AXIS, 0, 1.0f, 1.0f, icon, new ImageIcon(iconFile.getAbsolutePath())) : new CompoundIcon(CompoundIcon.Axis.Z_AXIS, 0, 1.0f, 1.0f, icon, Const.ICON_CATEGORY_OVERLAY_URL));
                    }
                    catch (URISyntaxException uRISyntaxException) {}
                    if (DownloadTools.isDownloadableFiletype(extra.getFilename())) {
                        icon = new CompoundIcon(CompoundIcon.Axis.Z_AXIS, 0, 0.0f, 1.0f, icon, Const.ICON_CATEGORY_OVERLAY_DOWNLOAD);
                    }
                }
                if (!extra.isUrl() && extra.isAdditional() && Const.EXTENSIONS_PACKED.matches(extra.getFilename())) {
                    icon = new CompoundIcon(CompoundIcon.Axis.Z_AXIS, 0, 1.0f, 1.0f, icon, Const.ICON_CATEGORY_OVERLAY_PACKED);
                }
                if (!extra.isUrl() && !Paths.getExtraPath().exists(new File(extra.getFilename()))) {
                    icon = new CompoundIcon(CompoundIcon.Axis.Z_AXIS, 0, 1.0f, 1.0f, icon, Const.ICON_CATEGORY_OVERLAY_MISSING);
                }
                JButton button = new JButton(icon);
                button.setToolTipText("<html>" + extra.getName() + (Databases.getCurrent().getPreferences().is("extras_show_filenames") ? "<br>" + extra.getFilename() : "") + "</html>");
                button.setActionCommand(Integer.toString(extra.getId()));
                button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        String command = evt.getActionCommand();
                        if (command != null && !command.isEmpty()) {
                            try {
                                int id = Integer.parseInt(command);
                                Extra extra = Db.getExtraById(id);
                                if (extra != null) {
                                    extra.play();
                                }
                            }
                            catch (IOException | NumberFormatException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                });
                button.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent evt) {
                        String command;
                        if (Gui.rightClick(evt) && (command = ((JButton)evt.getComponent()).getActionCommand()) != null && !command.isEmpty()) {
                            try {
                                JPopupMenu popupMenu;
                                int id = Integer.parseInt(command);
                                Extra extra = Db.getExtraById(id);
                                if (extra != null && (popupMenu = GuiMethods.this.createButtonsForExtrasPopupMenu(extra)) != null) {
                                    popupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
                                }
                            }
                            catch (NumberFormatException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                });
                this.sideButtonPanel.add(button);
                addedSomething = true;
            }
        }
        if (addedSomething) {
            this.sideButtonPanel.add(new JSeparator(1));
        }
    }

    @Override
    protected void about() {
        new AboutDialog((Frame)JGameBase.getGui(), true);
    }

    @Override
    protected void addToRecent(Item item2) {
        while (this.recent.contains(item2)) {
            this.recent.remove(item2);
        }
        this.recent.add(0, item2);
        if (this.recent.size() > 10) {
            this.recent.remove(this.recent.size() - 1);
        }
        this.recentMenu.removeAll();
        int i = 0;
        for (Item item2 : this.recent) {
            JMenuItem menuItem = new JMenuItem(item2.getName(), item2.getIcon());
            menuItem.setActionCommand(Integer.toString(i));
            menuItem.addActionListener(e -> {
                Const.log.info((Object)("recent: " + e.getActionCommand()));
                int i1 = Integer.parseInt(e.getActionCommand());
                Item item1 = this.recent.get(i1);
                this.selectItem(item1.getStringId(), false);
                this.addToRecent(item1);
                try {
                    item1.play();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            });
            this.recentMenu.add(menuItem);
            ++i;
        }
    }

    @Override
    protected void displayItem(Item item) {
        Component component;
        Component[] components;
        if (item == null) {
            this.status0.setText(" ");
            this.infoTabbedPane.removeAll();
            this.sidePanel_GameImage.removeAll();
            this.sidePanel_AdditionalImage.removeAll();
            this.sideButtonPanel.removeAll();
            this.sidePanel.repaint();
            this.filterPlayGameButton.setEnabled(false);
            this.filterPlayMusicButton.setEnabled(false);
            this.filterExtrasButton.setEnabled(false);
            this.filterAdditionalExtrasButton.setEnabled(false);
            this.lastItem = item;
            return;
        }
        if (item == this.lastItem) {
            return;
        }
        if (item.getId() == 0 && this.lastItem != null) {
            item = this.lastItem;
        }
        if (this.lastItem == null) {
            this.lastItem = item instanceof Game ? new Music() : new Game();
        }
        if (this.lastItem instanceof Music && item instanceof Game) {
            this.infoTabbedPane.removeAll();
            this.infoTabbedPane.addTab("Game", Const.ICON_TAB_GAME, this.gameInfoPanel, "");
            this.infoTabbedPane.addTab("Version", Const.ICON_TAB_VERSION, this.versionInfoPanel, "");
            this.infoTabbedPane.addTab("Personal", Const.ICON_TAB_PERSONAL, this.personalInfoPanel, "");
            this.infoTabbedPane.addTab("Notes", Const.ICON_TAB_NONOTES, this.notesInfoPanel, "");
            this.infoTabbedPane.addTab("Music", Const.ICON_TAB_MUSIC, this.musicInfoPanel, "");
            this.infoTabbedPane.setSelectedIndex(this.currentTab);
        } else if (this.lastItem instanceof Game && item instanceof Music) {
            this.currentTab = this.infoTabbedPane.getSelectedIndex();
            this.infoTabbedPane.removeAll();
            this.infoTabbedPane.addTab("Music", Const.ICON_TAB_ONLYMUSIC, this.musicInfoPanel, "");
        }
        this.status0.setText(item.getStringId());
        Component[] componentArray = components = this.sidePanel_GameImage.getComponents();
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            component = componentArray[n2];
            if (component instanceof flushable) {
                ((flushable)((Object)component)).flush();
            }
            ++n2;
        }
        this.sidePanel_GameImage.removeAll();
        componentArray = components = this.sidePanel_AdditionalImage.getComponents();
        n = components.length;
        n2 = 0;
        while (n2 < n) {
            component = componentArray[n2];
            if (component instanceof flushable) {
                ((flushable)((Object)component)).flush();
            }
            ++n2;
        }
        this.sidePanel_AdditionalImage.removeAll();
        this.sideButtonPanel.removeAll();
        this.sidePanel.repaint();
        if (item instanceof Game) {
            this.displayGame((Game)item);
        }
        if (item instanceof Music) {
            this.displayMusic((Music)item);
        }
        this.lastItem = item;
    }

    private void displayGame(Game game) {
        try {
            if (game == null || game.getName() == null || game.getId() == 0) {
                return;
            }
            this.filterPlayGameButton.setEnabled(game.getGameFileExists());
            this.filterPlayMusicButton.setEnabled(game.getMusicFileExists());
            this.filterExtrasButton.setEnabled(game.getHasExtras());
            this.filterAdditionalExtrasButton.setEnabled(true);
            this.setGameMenusEnabled(true);
            this.sidePanel_GameImage.setLayout(new BoxLayout(this.sidePanel_GameImage, 1));
            List<Extra> extras = game.getExtras();
            this.numExtraImagesShown = 0;
            List<String> screenshotFilenames = game.getScreenshotFilenames();
            if (screenshotFilenames.size() > 0) {
                this.sidePanel_GameImage.add(new JTitledSeparator("Screenshots"));
                int i = 1;
                for (String filename : screenshotFilenames) {
                    try {
                        if (FileTools.isAnimation(filename)) {
                            this.sidePanel_GameImage.add(new JScalingAnimation(filename, "<html>Screenshot #" + i + " for '" + game.getName() + "'" + (Databases.getCurrent().getPreferences().is("extras_show_filenames") ? "<br>" + filename : "") + "</html>"));
                        } else {
                            JZoomableScalingImage image = JZoomableScalingImage.createOrGet(filename);
                            String tooltip = "<html>Screenshot #" + i + " for '" + game.getName() + "'" + (Databases.getCurrent().getPreferences().is("extras_show_filenames") ? "<br>" + filename : "") + "<br><br>" + "<i>Left click</i> to open with external viewer specified in options<br>" + "<i>Right click</i> to open with internal viewer</html>";
                            image.setTooltip(tooltip);
                            image.startLoadingImage();
                            this.sidePanel_GameImage.add(image);
                        }
                        ++i;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.sidePanel_GameImage.add(new JLongSeparator());
                }
            }
            if (screenshotFilenames.size() == 0 && this.filterExtrasByCategory(extras, Extra.Category.GameImage).size() == 0) {
                JScalingIcon noScreenshot = Databases.getCurrent().hasMissingScreenshotIcon() ? new JScalingIcon(Databases.getCurrent().getMissingScreenshotIcon()) : new JScalingIcon(Const.ICON_MISSINGSCREENSHOT);
                noScreenshot.setToolTipText("No screenshot for '" + game.getName() + "'");
                this.sidePanel_GameImage.add(noScreenshot);
            }
            this.addAnimationsForExtrasToSideBar(this.sidePanel_GameImage, "Additional Game Animations", this.filterExtrasByCategory(extras, Extra.Category.GameImage));
            this.numExtraImagesShown = 0;
            this.gameImages = new ArrayList<JScalingImage>();
            this.addImagesForExtrasToSideBar(this.sidePanel_GameImage, this.gameImages, "Additional Game Images", this.filterExtrasByCategory(extras, Extra.Category.GameImage));
            this.addImagesForExtrasToSideBar(this.sidePanel_GameImage, this.gameImages, "Documentation", this.filterExtrasByCategory(extras, Extra.Category.Documentation));
            this.addImagesForExtrasToSideBar(this.sidePanel_GameImage, this.gameImages, "Manual", this.filterExtrasByCategory(extras, Extra.Category.Documentation_Manual));
            this.addImagesForExtrasToSideBar(this.sidePanel_GameImage, this.gameImages, "Solution", this.filterExtrasByCategory(extras, Extra.Category.Solution));
            this.addImagesForExtrasToSideBar(this.sidePanel_GameImage, this.gameImages, "Map", this.filterExtrasByCategory(extras, Extra.Category.Solution_Map));
            this.addImagesForExtrasToSideBar(this.sidePanel_GameImage, this.gameImages, "Tip", this.filterExtrasByCategory(extras, Extra.Category.Solution_Tip));
            this.addImagesForExtrasToSideBar(this.sidePanel_GameImage, this.gameImages, "Walkthrough", this.filterExtrasByCategory(extras, Extra.Category.Solution_walkthrough));
            this.addImagesForExtrasToSideBar(this.sidePanel_GameImage, this.gameImages, "Review", this.filterExtrasByCategory(extras, Extra.Category.Review));
            this.numExtraImagesShown = 0;
            this.additionalImages = new ArrayList<JScalingImage>();
            this.addImagesForExtrasToSideBar(this.sidePanel_AdditionalImage, this.additionalImages, "Additional Images", this.filterExtrasByCategory(extras, Extra.Category.AdditionalImage));
            this.addImagesForExtrasToSideBar(this.sidePanel_AdditionalImage, this.additionalImages, "Cover", this.filterExtrasByCategory(extras, Extra.Category.AdditionalImage_Cover));
            this.addImagesForExtrasToSideBar(this.sidePanel_AdditionalImage, this.additionalImages, "Advertisements", this.filterExtrasByCategory(extras, Extra.Category.AdditionalImage_Advertisement));
            this.addImagesForExtrasToSideBar(this.sidePanel_AdditionalImage, this.additionalImages, "Book Cover", this.filterExtrasByCategory(extras, Extra.Category.AdditionalImage_Bookcover));
            this.addImagesForExtrasToSideBar(this.sidePanel_AdditionalImage, this.additionalImages, "Movie", this.filterExtrasByCategory(extras, Extra.Category.Movie));
            this.addImagesForExtrasToSideBar(this.sidePanel_AdditionalImage, this.additionalImages, "Media", this.filterExtrasByCategory(extras, Extra.Category.Media));
            this.addImagesForExtrasToSideBar(this.sidePanel_AdditionalImage, this.additionalImages, "Cartridge", this.filterExtrasByCategory(extras, Extra.Category.Media_Cartridge));
            this.addImagesForExtrasToSideBar(this.sidePanel_AdditionalImage, this.additionalImages, "Tape", this.filterExtrasByCategory(extras, Extra.Category.Media_Tape));
            this.addImagesForExtrasToSideBar(this.sidePanel_AdditionalImage, this.additionalImages, "Disk", this.filterExtrasByCategory(extras, Extra.Category.Media_Disk));
            this.addImagesForExtrasToSideBar(this.sidePanel_AdditionalImage, this.additionalImages, "Harddisk", this.filterExtrasByCategory(extras, Extra.Category.Media_Harddisk));
            this.addImagesForExtrasToSideBar(this.sidePanel_AdditionalImage, this.additionalImages, "Miscellany", this.filterExtrasByCategory(extras, Extra.Category.Misc));
            this.linkAndStartImageList(this.gameImages);
            this.linkAndStartImageList(this.additionalImages);
            this.addButtonsForExtrasToSidebar(this.filterExtrasByCategory(extras, Extra.Category.GameImage));
            this.addButtonsForExtrasToSidebar(this.filterExtrasByCategory(extras, Extra.Category.Movie));
            this.addButtonsForExtrasToSidebar(this.filterExtrasByCategory(extras, Extra.Category.AdditionalImage));
            this.addButtonsForExtrasToSidebar(this.filterExtrasByCategory(extras, Extra.Category.AdditionalImage_Cover));
            this.addButtonsForExtrasToSidebar(this.filterExtrasByCategory(extras, Extra.Category.AdditionalImage_Advertisement));
            this.addButtonsForExtrasToSidebar(this.filterExtrasByCategory(extras, Extra.Category.AdditionalImage_Bookcover));
            this.addButtonsForExtrasToSidebar(this.filterExtrasByCategory(extras, Extra.Category.Documentation));
            this.addButtonsForExtrasToSidebar(this.filterExtrasByCategory(extras, Extra.Category.Documentation_Manual));
            this.addButtonsForExtrasToSidebar(this.filterExtrasByCategory(extras, Extra.Category.Solution));
            this.addButtonsForExtrasToSidebar(this.filterExtrasByCategory(extras, Extra.Category.Solution_Map));
            this.addButtonsForExtrasToSidebar(this.filterExtrasByCategory(extras, Extra.Category.Solution_Tip));
            this.addButtonsForExtrasToSidebar(this.filterExtrasByCategory(extras, Extra.Category.Solution_walkthrough));
            this.addButtonsForExtrasToSidebar(this.filterExtrasByCategory(extras, Extra.Category.Review));
            this.addButtonsForExtrasToSidebar(this.filterExtrasByCategory(extras, Extra.Category.Media));
            this.addButtonsForExtrasToSidebar(this.filterExtrasByCategory(extras, Extra.Category.Media_Cartridge));
            this.addButtonsForExtrasToSidebar(this.filterExtrasByCategory(extras, Extra.Category.Media_Tape));
            this.addButtonsForExtrasToSidebar(this.filterExtrasByCategory(extras, Extra.Category.Media_Disk));
            this.addButtonsForExtrasToSidebar(this.filterExtrasByCategory(extras, Extra.Category.Media_Harddisk));
            this.addButtonsForExtrasToSidebar(this.filterExtrasByCategory(extras, Extra.Category.Misc));
            this.sideButtonPanelResized();
            this.gameInfoPrequel.setIcon(Const.ICON_GAMEINFO_NOPREQUEL);
            if (game.hasPrequel()) {
                this.gameInfoPrequel.setIcon(Const.ICON_GAMEINFO_PREQUEL);
            }
            this.gameInfoSequel.setIcon(Const.ICON_GAMEINFO_NOSEQUEL);
            if (game.hasSequel()) {
                this.gameInfoSequel.setIcon(Const.ICON_GAMEINFO_SEQUEL);
            }
            this.gameInfoRelated.setIcon(Const.ICON_GAMEINFO_NORELATED);
            if (game.hasRelated()) {
                this.gameInfoRelated.setIcon(Const.ICON_GAMEINFO_RELATED);
            }
            this.gameInfoRating.setIcon(Const.ICONS_GAMEINFO_RATING[game.getRating()]);
            this.gameInfoRating.setToolTipText(Const.FORDISPLAY_RATING[game.getRating()]);
            this.gameInfoAdult.setIcon(Const.ICON_GAMEINFO_NOADULT);
            if (game.getIsAdult()) {
                this.gameInfoAdult.setIcon(Const.ICON_GAMEINFO_ADULT);
            }
            this.editMenu_SetGameLink.setEnabled(this.linkGame != null && game != this.linkGame);
            this.editMenu_ClearGameLink.setEnabled(game.hasPrequel() || game.hasSequel() || game.hasRelated());
            this.gameInfoTitle.setText(game.getName());
            this.gameInfoTitleLeft.setIcon(null);
            this.gameInfoTitleRight.setIcon(null);
            if (game.getIsClassic()) {
                this.gameInfoTitleLeft.setIcon(Const.ICON_GAMEINFO_CLASSIC);
                this.gameInfoTitleRight.setIcon(Const.ICON_GAMEINFO_CLASSIC);
            }
            this.gameInfoYear.setText(game.getYear().getName());
            this.gameInfoPublisher.setText(game.getPublisher().getName());
            this.gameInfoCoding.setText(game.getProgrammer().getName());
            this.gameInfoMusic.setText(game.getMusician().getName());
            this.gameInfoGenre.setText(game.getGenreForDisplay());
            this.gameInfoNoOfPlayers.setText(game.getPlayersForDisplay());
            this.gameInfoLanguage.setText(game.getLanguage().getName());
            this.gameInfoComment.setText(String.valueOf(game.getComment()) + " ");
            this.versionInfoTitle.setText(game.getName());
            this.versionInfoTitleLeft.setIcon(null);
            this.versionInfoTitleRight.setIcon(null);
            if (game.getIsClassic()) {
                this.versionInfoTitleLeft.setIcon(Const.ICON_GAMEINFO_CLASSIC);
                this.versionInfoTitleRight.setIcon(Const.ICON_GAMEINFO_CLASSIC);
            }
            this.versionInfoCracked.setText(game.getCracker().getName());
            this.versionInfoNoOfTrainers.setText(game.getTrainerForDisplay());
            this.versionInfoHighScoreSaver.setText(game.getHasHighscoreSaverForDisplay());
            this.versionInfoGamelength.setText(game.getLengthForDisplay());
            this.versionInfoPalNTSC.setText(game.getPalNtscForDisplay());
            this.versionInfoTrueDriveEmu.setText(game.getNeedsTruedriveEmuForDisplay());
            this.versionInfoLoadingScreen.setText(game.getHasLoadingScreenForDisplay());
            this.versionInfoIncludedDocs.setText(game.getHasIncludedDocsForDisplay());
            this.versionInfoComment.setText(String.valueOf(game.getVersionComment()) + " ");
            this.personalInfoTitle.setText(game.getName());
            this.personalInfoTitleLeft.setIcon(null);
            this.personalInfoTitleRight.setIcon(null);
            if (game.getIsClassic()) {
                this.personalInfoTitleLeft.setIcon(Const.ICON_GAMEINFO_CLASSIC);
                this.personalInfoTitleRight.setIcon(Const.ICON_GAMEINFO_CLASSIC);
            }
            this.personalInfoHighScore.setText(game.getHighscoreForDisplay());
            this.personalInfoDifficulty.setText(game.getDifficulty().getName());
            this.personalInfoTimesPlayed.setText(game.getTimesPlayedForDisplay());
            this.personalInfoLastPlayed.setText(game.getDateLastPlayedForDisplay());
            this.personalInfoRating.setText(game.getRatingForDisplay());
            this.notesInfoTitle.setText(game.getName());
            this.notesInfoTitleLeft.setIcon(null);
            this.notesInfoTitleRight.setIcon(null);
            if (game.getIsClassic()) {
                this.notesInfoTitleLeft.setIcon(Const.ICON_GAMEINFO_CLASSIC);
                this.notesInfoTitleRight.setIcon(Const.ICON_GAMEINFO_CLASSIC);
            }
            this.notesInfoNote.setText(game.getNote());
            if (!game.getNote().isEmpty()) {
                this.infoTabbedPane.setIconAt(3, Const.ICON_TAB_NOTES);
            }
            this.musicInfoTitle.setText(game.getName());
            this.musicInfoTitleLeft.setIcon(null);
            this.musicInfoTitleRight.setIcon(null);
            if (game.getIsClassic()) {
                this.musicInfoTitleLeft.setIcon(Const.ICON_GAMEINFO_CLASSIC);
                this.musicInfoTitleRight.setIcon(Const.ICON_GAMEINFO_CLASSIC);
            }
            Musician musician = game.getMusician();
            this.musicInfoMusician.setText(musician.getNameForDisplay());
            this.musicInfoNickname.setText(musician.getNicknameForDisplay());
            this.musicInfoGroup.setText(musician.getGroupForDisplay());
            this.musicInfoPhoto.setText(musician.getPhotoFilenameForDisplay());
            this.musicInfoName.setText("");
            this.musicInfoAuthor.setText("");
            this.musicInfoCopyright.setText("");
            this.musicInfoSongs.setText("");
            this.musicInfoDefault.setText("");
            MusicInfo musicInfo = null;
            try {
                if (Plugins.existsMusicInfoForExtension(FileTools.getExtension(game.getMusicFilename()))) {
                    musicInfo = Plugins.getMusicInfoForExtension(FileTools.getExtension(game.getMusicFilename()));
                    musicInfo.load(Paths.getMusicPath().find(new File(game.getMusicFilename())));
                }
            }
            catch (IOException iOException) {
                musicInfo = null;
            }
            if (musicInfo != null) {
                this.musicInfoName.setText(musicInfo.getName());
                this.musicInfoAuthor.setText(musicInfo.getAuthor());
                this.musicInfoCopyright.setText(musicInfo.getCopyright());
                this.musicInfoSongs.setText(musicInfo.getSongNumber());
                this.musicInfoDefault.setText(musicInfo.getDefaultSong());
            }
            if (!game.getFilename().isEmpty()) {
                this.status1.setText("[v" + (game.getVersion() < 10 ? "0" : "") + game.getVersion() + "] " + game.getFilename() + " ");
            } else {
                this.status1.setText("None");
            }
            if (!game.getMusicFilename().isEmpty()) {
                this.status2.setText(game.getMusicFilename());
            } else {
                this.status2.setText("None");
            }
            if (game.getIsClassic() && Databases.getCurrent().getPreferences().is("sound_on_classics")) {
                if (Databases.getCurrent().hasClassicSound()) {
                    Databases.getCurrent().getClassicSound().play();
                } else {
                    Const.SOUND_CLASSIC.play();
                }
            }
            this.sidePanel.validate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void linkAndStartImageList(List<JScalingImage> list) {
        JScalingImage lastImage = null;
        for (JScalingImage image : list) {
            if (lastImage != null) {
                lastImage.setChainedImage(image);
            }
            lastImage = image;
        }
        if (!list.isEmpty()) {
            list.get(0).startLoadingImage();
        }
    }

    @Override
    protected void sideButtonPanelResized() {
        int height = 54;
        this.sideButtonPanel.setPreferredSize(new Dimension(this.sideButtonPanel.getParent().getWidth(), height));
        this.sideButtonPanel.validate();
        if (this.sideButtonPanel.getComponentCount() > 0) {
            height += this.sideButtonPanel.getComponent(this.sideButtonPanel.getComponentCount() - 1).getY();
            this.sideButtonPanel.scrollRectToVisible(new Rectangle());
        }
        this.sideButtonPanel.setPreferredSize(new Dimension(this.sideButtonPanel.getParent().getWidth(), height));
        this.sideButtonPanel.validate();
    }

    private void displayMusic(final Music music) {
        if (music == null || music.getName() == null) {
            return;
        }
        Musician musician = music.getMusician();
        this.filterPlayGameButton.setEnabled(false);
        this.filterPlayMusicButton.setEnabled(music.getFileExists());
        this.filterExtrasButton.setEnabled(false);
        this.filterAdditionalExtrasButton.setEnabled(false);
        this.setGameMenusEnabled(false);
        this.sidePanel_GameImage.setLayout(new BorderLayout());
        JLabel photo = new JLabel(musician.getNameForDisplay(), musician.getPhoto(), 0);
        photo.setHorizontalTextPosition(0);
        photo.setVerticalTextPosition(3);
        photo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Musician musician = new MusicianDialog(music.getMusician()).get();
                if (musician != null) {
                    Db.saveOrUpdate(musician);
                    GuiMethods.this.updateItemTable();
                }
            }
        });
        this.sidePanel_GameImage.add((Component)photo, "Center");
        this.gameInfoPrequel.setIcon(Const.ICON_GAMEINFO_NOPREQUEL);
        this.gameInfoSequel.setIcon(Const.ICON_GAMEINFO_NOSEQUEL);
        this.gameInfoRelated.setIcon(Const.ICON_GAMEINFO_NORELATED);
        this.gameInfoRating.setIcon(Const.ICONS_GAMEINFO_RATING[0]);
        this.gameInfoAdult.setIcon(Const.ICON_GAMEINFO_NOADULT);
        if (music.getIsAdult()) {
            this.gameInfoAdult.setIcon(Const.ICON_GAMEINFO_ADULT);
        }
        this.editMenu_MarkGameForLinking.setEnabled(false);
        this.editMenu_SetGameLink.setEnabled(false);
        this.editMenu_ClearGameLink.setEnabled(false);
        this.musicInfoTitle.setText(music.getName());
        this.musicInfoTitleLeft.setIcon(null);
        this.musicInfoTitleRight.setIcon(null);
        this.musicInfoMusician.setText(musician.getNameForDisplay());
        this.musicInfoNickname.setText(musician.getNicknameForDisplay());
        this.musicInfoGroup.setText(musician.getGroupForDisplay());
        this.musicInfoPhoto.setText(musician.getPhotoFilenameForDisplay());
        this.musicInfoName.setText("");
        this.musicInfoAuthor.setText("");
        this.musicInfoCopyright.setText("");
        this.musicInfoSongs.setText("");
        this.musicInfoDefault.setText("");
        MusicInfo musicInfo = null;
        try {
            if (Plugins.existsMusicInfoForExtension(FileTools.getExtension(music.getFilename()))) {
                musicInfo = Plugins.getMusicInfoForExtension(FileTools.getExtension(music.getFilename()));
                musicInfo.load(Paths.getMusicPath().find(new File(music.getFilename())));
            }
        }
        catch (IOException iOException) {
            musicInfo = null;
        }
        if (musicInfo != null) {
            this.musicInfoName.setText(musicInfo.getName());
            this.musicInfoAuthor.setText(musicInfo.getAuthor());
            this.musicInfoCopyright.setText(musicInfo.getCopyright());
            this.musicInfoSongs.setText(musicInfo.getSongNumber());
            this.musicInfoDefault.setText(musicInfo.getDefaultSong());
        }
        this.status1.setText(" ");
        this.status2.setText(String.valueOf(music.getFilename()) + " ");
        this.sidePanel.validate();
    }

    protected void setGameMenusEnabled(boolean b) {
        this.editMenu_VersionInfoMenu.setEnabled(b);
        this.editMenu_PersonalInfoMenu.setEnabled(b);
        this.editMenu_GameFile.setEnabled(b);
        this.editMenu_Screenshots.setEnabled(b);
        this.editMenu_Extras.setEnabled(b);
        this.editMenu_AdditionalExtras.setEnabled(b);
        this.editMenu_KeyValuePairs.setEnabled(b);
        this.editMenu_MarkGameForLinking.setEnabled(b);
        this.editMenu_SetGameLink.setEnabled(b);
        this.editMenu_ClearGameLink.setEnabled(b);
    }

    @Override
    public void selectItem(String idString, boolean displayWarnings) {
        int id;
        ItemTableModel data = (ItemTableModel)this.itemTable.getModel();
        if ("INVALID".equals(idString = idString.toUpperCase())) {
            return;
        }
        if (idString.isEmpty()) {
            data.setSelectedRow(0);
            return;
        }
        try {
            id = Integer.parseInt(idString.substring(1));
        }
        catch (Exception exception) {
            if (displayWarnings) {
                JOptionPane.showMessageDialog(null, "Invalid item id specified!", "jGameBase", 2);
            }
            return;
        }
        boolean found = false;
        int row = 0;
        Iterator<Item> iter = data.iterator();
        while (iter.hasNext() && !found) {
            Item item = iter.next();
            if (item.getId() == id && (item instanceof Game && idString.startsWith("G") || item instanceof Music && idString.startsWith("M"))) {
                found = true;
            }
            ++row;
        }
        if (found) {
            data.setSelectedRow(row - 1);
        } else if (displayWarnings) {
            if (idString.startsWith("G") && this.filterViewCombobox.getSelectedIndex() != 0) {
                int answer = JOptionPane.showConfirmDialog(this, "The Game you requested was not found in the current view!\n\nDo you want me to change to the '<All Games>' view so that I can show you the Game?", "jGameBase", 0);
                if (answer == 0) {
                    this.filterViewCombobox.setSelectedIndex(0);
                    data.setView((ItemView)this.views.get(0));
                    this.selectItem(idString, displayWarnings);
                }
                return;
            }
            if (idString.startsWith("M") && this.filterViewCombobox.getSelectedIndex() != 2) {
                int answer = JOptionPane.showConfirmDialog(this, "The Music you requested was not found in the current view!\n\nDo you want me to change to the '<All Music>' view so that I can show you the Music?", "jGameBase", 0);
                if (answer == 0) {
                    this.filterViewCombobox.setSelectedIndex(2);
                    data.setView((ItemView)this.views.get(2));
                    this.selectItem(idString, displayWarnings);
                }
                return;
            }
            JOptionPane.showMessageDialog(this, "The Game/Music was not found in the list!", "jGameBase", 2);
        } else {
            data.setSelectedRow(0);
        }
    }

    @Override
    protected void addView() {
        ItemView view = new ItemView();
        view.setName("New View");
        view.setType(0);
        view.setMode(0);
        view.setInclude(0);
        view.setFilters(new HashSet<ItemViewFilter>());
        ViewDialog viewDialog = new ViewDialog(view, "Add Custom View");
        if (viewDialog.getCloseAction() == Const.CloseAction.OK) {
            ItemView newView = viewDialog.getView();
            view.setName(newView.getName());
            view.setMode(newView.getMode());
            view.setInclude(newView.getInclude());
            view.setFilters(newView.getFilters());
            newView.setFilters(null);
            this.views.add(view);
            Collections.sort(this.views);
            this.filterViewCombobox.setModel(new DefaultComboBoxModel<Object>(this.views.toArray()));
            this.filterViewCombobox.setSelectedItem(view);
            Db.saveOrUpdate(view);
            ((ItemTableModel)this.itemTable.getModel()).setView(view);
            ((ItemTableModel)this.itemTable.getModel()).reloadView();
        }
        viewDialog.dispose();
    }

    @Override
    protected void editView() {
        ItemView view = (ItemView)this.filterViewCombobox.getSelectedItem();
        int row = this.filterViewCombobox.getSelectedIndex();
        if (view.getType() != 0) {
            return;
        }
        ViewDialog viewDialog = new ViewDialog(view, "Edit Custom View");
        if (viewDialog.getCloseAction() == Const.CloseAction.OK) {
            ItemView newView = viewDialog.getView();
            view.setName(newView.getName());
            view.setMode(newView.getMode());
            view.setInclude(newView.getInclude());
            view.setFilters(newView.getFilters());
            newView.setFilters(null);
            this.views.set(row, view);
            this.filterViewCombobox.setModel(new DefaultComboBoxModel<Object>(this.views.toArray()));
            this.filterViewCombobox.setSelectedIndex(row);
            Db.saveOrUpdate(view);
            ((ItemTableModel)this.itemTable.getModel()).setView(view);
            ((ItemTableModel)this.itemTable.getModel()).reloadView();
        }
        viewDialog.dispose();
    }

    @Override
    protected void removeView() {
        ItemView view = (ItemView)this.filterViewCombobox.getSelectedItem();
        if (view.getType() == 0) {
            Db.delete(view);
            this.views.remove(view);
            this.filterViewCombobox.setModel(new DefaultComboBoxModel<Object>(this.views.toArray()));
            view = (ItemView)this.filterViewCombobox.getSelectedItem();
            ((ItemTableModel)this.itemTable.getModel()).setView(view);
        }
    }

    @Override
    protected boolean clicked(MouseEvent evt) {
        return evt.getButton() == 1 && evt.getClickCount() == 1;
    }

    @Override
    protected synchronized Item getSelectedItem() {
        ItemTableModel data = (ItemTableModel)this.itemTable.getModel();
        return data.getItem(data.getSelectedRow());
    }

    @Override
    protected Game getSelectedGame() {
        if (this.isSelectedItemOfTypeGame()) {
            return (Game)this.getSelectedItem();
        }
        return null;
    }

    @Override
    protected Music getSelectedMusic() {
        if (this.isSelectedItemOfTypeMusic()) {
            return (Music)this.getSelectedItem();
        }
        return null;
    }

    @Override
    protected ItemView createQuickview(String name, int include) {
        ItemView view = new ItemView();
        ItemView currentView = (ItemView)this.filterViewCombobox.getSelectedItem();
        view.setName("[" + name + "]");
        view.setInclude(include);
        view.setType(2);
        view.setSortColumn(currentView.getSortColumn());
        view.setSortOrder(currentView.getSortOrder());
        return view;
    }

    @Override
    protected void setQuickview(ItemView view) {
        int row = -1;
        int i = 0;
        for (ItemView viewInList : this.views) {
            if (viewInList.getType() == 2) {
                row = i;
            }
            ++i;
        }
        if (row == -1) {
            this.views.add(view);
        } else {
            this.views.set(row, view);
        }
        this.filterViewCombobox.setModel(new DefaultComboBoxModel<Object>(this.views.toArray()));
        this.filterViewCombobox.setSelectedItem(view);
        ((ItemTableModel)this.itemTable.getModel()).setView(view);
        if (this.getSelectedItem() != null) {
            this.selectItem(this.getSelectedItem().getStringId(), false);
        }
    }

    @Override
    protected void editGameMusicInfo_Current() {
        this.saveItemTablePosition();
        if (this.isSelectedItemOfTypeGame()) {
            new GameInfoDialog(this.getSelectedGame());
        } else {
            new MusicInfoDialog(this.getSelectedMusic());
        }
        this.displaySelectedItem(false);
        this.loadItemTablePosition();
    }

    @Override
    protected void editGameMusicInfo_All() {
        this.saveItemTablePosition();
        if (this.isSelectedItemOfTypeGame()) {
            new GameInfoDialog(((ItemView)this.filterViewCombobox.getSelectedItem()).getData());
        } else {
            new MusicInfoDialog(((ItemView)this.filterViewCombobox.getSelectedItem()).getData());
        }
        this.displaySelectedItem(false);
        this.loadItemTablePosition();
    }

    protected boolean isSelectedItemOfTypeGame() {
        return this.getSelectedItem() != null && this.getSelectedItem() instanceof Game;
    }

    protected boolean isSelectedItemOfTypeMusic() {
        return this.getSelectedItem() != null && this.getSelectedItem() instanceof Music;
    }

    @Override
    protected void toggleIsFavourite() {
        Item item = this.getSelectedItem();
        if (item != null) {
            item.setIsFavourite(!item.getIsFavourite());
            Db.saveOrUpdate(item);
            ((ItemView)this.views.get(4)).clearCache();
            this.updateItemTable();
        }
    }

    @Override
    protected void editVersionInfo_Current() {
        this.saveItemTablePosition();
        new VersionInfoDialog(this.getSelectedGame());
        this.loadItemTablePosition();
    }

    @Override
    protected void editVersionInfo_All() {
        this.saveItemTablePosition();
        new VersionInfoDialog(((ItemView)this.filterViewCombobox.getSelectedItem()).getData());
        this.loadItemTablePosition();
    }

    @Override
    protected void editPersonalInfo_Current() {
        this.saveItemTablePosition();
        new PersonalInfoDialog(this.getSelectedGame());
        this.loadItemTablePosition();
    }

    @Override
    protected void editPersonalInfo_All() {
        this.saveItemTablePosition();
        new PersonalInfoDialog(((ItemView)this.filterViewCombobox.getSelectedItem()).getData());
        this.loadItemTablePosition();
    }

    private void saveItemTablePosition() {
        this.itemTableSavedPosition_Rect = this.itemTable.getVisibleRect();
        this.itemTableSavedPosition_Row = this.itemTable.getSelectedRow();
        if (this.itemTableSavedPosition_Row < 0 || this.itemTableSavedPosition_Row > this.itemTable.getRowCount()) {
            this.itemTableSavedPosition_Row = 0;
            if (this.itemTable.getRowCount() > 0) {
                this.itemTable.setRowSelectionInterval(0, 0);
            }
        }
    }

    private void loadItemTablePosition() {
        try {
            ((ItemTableModel)this.itemTable.getModel()).fireTableDataChanged();
            this.itemTable.scrollRectToVisible(this.itemTableSavedPosition_Rect);
            if (this.itemTableSavedPosition_Row < this.itemTable.getRowCount()) {
                this.itemTable.setRowSelectionInterval(this.itemTableSavedPosition_Row, this.itemTableSavedPosition_Row);
            }
            this.displaySelectedItem(false);
        }
        catch (Exception exception) {}
    }

    @Override
    protected void displaySelectedItem(boolean forceUpdate) {
        if (forceUpdate) {
            this.lastItem = null;
        }
        this.displayItem(this.getSelectedItem());
    }

    @Override
    protected void updateItemTable() {
        this.saveItemTablePosition();
        this.displaySelectedItem(false);
        this.loadItemTablePosition();
    }

    @Override
    protected void togglePlaySoundOnClassics() {
        Databases.getCurrent().getPreferences().set("sound_on_classics", !Databases.getCurrent().getPreferences().is("sound_on_classics"));
        this.toolsMenu_PlaySoundOnClassics.setSelected(Databases.getCurrent().getPreferences().is("sound_on_classics"));
        this.status5.setIcon(Databases.getCurrent().getPreferences().is("sound_on_classics") ? Const.ICON_SOUND_ON : Const.ICON_SOUND_OFF);
    }

    @Override
    protected void toggleHardwareJoystick() {
        Databases.getCurrent().getPreferences().set("hardware_joystick", !Databases.getCurrent().getPreferences().is("hardware_joystick"));
        this.toolsMenu_HardwareJoystick.setSelected(Databases.getCurrent().getPreferences().is("hardware_joystick"));
        this.status6.setIcon(Databases.getCurrent().getPreferences().is("hardware_joystick") ? Const.ICON_JOYSTICK_ON : Const.ICON_JOYSTICK_OFF);
    }

    @Override
    protected void toggleAdultFilter() {
        if (Databases.getCurrent().getPreferences().is("adult_filter")) {
            long pw;
            String s = (String)JOptionPane.showInputDialog(this, "Please enter the current Password:", "Enter Password", 3, null, null, "");
            if (s == null) {
                s = "";
            }
            if ((pw = FileTools.checksum(s)) == Databases.getCurrent().getPreferences().getLong("adult_filter_pw")) {
                Databases.getCurrent().getPreferences().set("adult_filter", false);
                Databases.getCurrent().getPreferences().set("adult_filter_pw", "");
            } else {
                Gui.displayErrorDialog("Wrong password!");
            }
        } else {
            long pw2;
            String s = (String)JOptionPane.showInputDialog(this, "Please enter a new Password:", "Enter Password", 3, null, null, "");
            if (s == null) {
                s = "";
            }
            long pw1 = FileTools.checksum(s);
            s = (String)JOptionPane.showInputDialog(this, "Please repeat the Password:", "Enter Password", 3, null, null, "");
            if (s == null) {
                s = "";
            }
            if (pw1 == (pw2 = FileTools.checksum(s))) {
                Databases.getCurrent().getPreferences().set("adult_filter", true);
                Databases.getCurrent().getPreferences().set("adult_filter_pw", pw1);
            } else {
                Gui.displayWarningDialog("Specified passwords were not identical!");
            }
        }
        this.toolsMenu_AdultFilter.setSelected(Databases.getCurrent().getPreferences().is("adult_filter"));
        this.clearAllViewCaches();
        this.reloadCurrentView();
    }

    @Override
    protected void importFavourites() {
        block22: {
            JFileChooser fileChooser = new JFileChooser();
            BufferedReader in = null;
            ArrayList<Item> list = new ArrayList<Item>();
            fileChooser.setFileFilter(this.csvFileFilter);
            fileChooser.setSelectedFile(new File("GameBase_Favourites_" + Databases.getCurrent().getName() + ".csv"));
            if (fileChooser.showOpenDialog(null) == 0) {
                File file = fileChooser.getSelectedFile();
                try {
                    try {
                        String line;
                        this.setCursor(Cursor.getPredefinedCursor(3));
                        Const.log.info((Object)"Marking the following items as favourites:");
                        in = new BufferedReader(new FileReader(file));
                        while ((line = in.readLine()) != null) {
                            Item item;
                            int index = 0;
                            if (line.indexOf(44) != -1 && line.indexOf(59) != -1) {
                                index = Math.min(line.indexOf(44), line.indexOf(59));
                            } else if (line.indexOf(44) != -1) {
                                index = line.indexOf(44);
                            } else if (line.indexOf(59) != -1) {
                                index = line.indexOf(59);
                            }
                            String id = line.substring(0, index);
                            if (id.startsWith("\"") && id.endsWith("\"")) {
                                id = id.substring(1, id.length() - 1);
                            }
                            if ((item = Db.getItembyId(id)) == null) continue;
                            Const.log.info((Object)("  marking item with id='" + item.getStringId() + "' and name='" + item.getName() + "'..."));
                            item.setIsFavourite(true);
                            list.add(item);
                        }
                        Db.saveOrUpdateAll(list);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {}
                        }
                        this.setCursor(Cursor.getPredefinedCursor(0));
                        Const.log.info((Object)"Finished marking items as favourite.");
                        break block22;
                    }
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    Const.log.info((Object)"Finished marking items as favourite.");
                    throw throwable;
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
                Const.log.info((Object)"Finished marking items as favourite.");
            }
        }
    }

    @Override
    protected void importDbFromCSV() {
        this.clearAllViewCaches();
        try {
            Import.csv2Db();
            Gui.displayInformationDialog("Import of current database from directory\n'" + new File(Databases.getCurrent().getPath(), "Export") + "'\nsuccessfully finished.");
        }
        catch (Exception e) {
            e.printStackTrace();
            Gui.displayErrorDialog(e.getMessage());
        }
        JGameBase.getGui().initViews();
        ((ItemTableModel)this.itemTable.getModel()).setView((ItemView)this.views.get(0));
    }

    @Override
    protected void exportFavourites() {
        JFileChooser fileChooser = new JFileChooser();
        PrintWriter out = null;
        fileChooser.setFileFilter(this.csvFileFilter);
        fileChooser.setSelectedFile(new File("GameBase_Favourites_" + Databases.getCurrent().getName() + ".csv"));
        if (fileChooser.showSaveDialog(null) == 0) {
            File file = fileChooser.getSelectedFile();
            try {
                try {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    if (!file.exists() || JOptionPane.showConfirmDialog(null, "Favourites file '" + file.getName() + "' exists.\nOverwrite?", "Warning", 0) == 0) {
                        out = new PrintWriter(file);
                        ItemView view = (ItemView)this.views.get(0);
                        List<Item> list = view.getData();
                        for (Item item : list) {
                            Game game = (Game)item;
                            if (!game.getIsFavourite()) continue;
                            out.println("G" + game.getId() + ",\"" + game.getName() + "\"");
                        }
                        view = (ItemView)this.views.get(2);
                        list = view.getData();
                        for (Item item : list) {
                            Music music;
                            if (!(item instanceof Music) || !(music = (Music)item).getIsFavourite()) continue;
                            out.println("M" + music.getId() + ",\"" + music.getName() + "\"");
                        }
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    if (out != null) {
                        out.close();
                    }
                    JGameBase.getGui().setCursor(Cursor.getPredefinedCursor(0));
                }
            }
            finally {
                if (out != null) {
                    out.close();
                }
                JGameBase.getGui().setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    @Override
    protected void exportUsedFiles() {
        File path = Databases.getCurrent().getPath();
        File gamesFile = new File(path, "games.ufl");
        File extrasFile = new File(path, "extras.ufl");
        File musicFile = new File(path, "music.ufl");
        File photosFile = new File(path, "photos.ufl");
        File screenshotsFile = new File(path, "screenshots.ufl");
        TreeSet<String> gamesFilenames = new TreeSet<String>();
        TreeSet<String> extrasFilenames = new TreeSet<String>();
        TreeSet<String> musicFilenames = new TreeSet<String>();
        TreeSet<String> photosFilenames = new TreeSet<String>();
        TreeSet<String> screenshotsFilenames = new TreeSet<String>();
        this.setCursor(Cursor.getPredefinedCursor(3));
        Const.log.info((Object)"Exporting list of used files...");
        gamesFile.delete();
        extrasFile.delete();
        musicFile.delete();
        photosFile.delete();
        screenshotsFile.delete();
        ItemView view = (ItemView)this.views.get(0);
        List<Item> list = view.getData();
        list.stream().map(item -> (Game)item).forEach(game -> {
            if (!game.getFilename().isEmpty()) {
                gamesFilenames.add(game.getFilename());
            }
            if (!game.getMusicFilename().isEmpty()) {
                musicFilenames.add(game.getMusicFilename());
            }
            if (!game.getMusician().getPhotoFilename().isEmpty()) {
                photosFilenames.add(game.getMusician().getPhotoFilename());
            }
            if (!game.getScreenshotFilename().isEmpty()) {
                screenshotsFilenames.add(game.getScreenshotFilename());
            }
            List<Extra> extras = game.getExtras();
            extras.stream().filter(extra -> !extra.getFilename().isEmpty()).forEach(extra -> {
                boolean bl = extrasFilenames.add(extra.getFilename());
            });
        });
        view = (ItemView)this.views.get(2);
        list = view.getData();
        list.stream().filter(item -> item instanceof Music).map(item -> (Music)item).forEach(music -> {
            if (!music.getFilename().isEmpty()) {
                musicFilenames.add(music.getFilename());
            }
            if (!music.getMusician().getPhotoFilename().isEmpty()) {
                photosFilenames.add(music.getMusician().getPhotoFilename());
            }
        });
        this.writeUsedFilesToFile(gamesFile, gamesFilenames);
        this.writeUsedFilesToFile(extrasFile, extrasFilenames);
        this.writeUsedFilesToFile(musicFile, musicFilenames);
        this.writeUsedFilesToFile(photosFile, photosFilenames);
        this.writeUsedFilesToFile(screenshotsFile, screenshotsFilenames);
        this.setCursor(Cursor.getPredefinedCursor(0));
        Const.log.info((Object)"Finished exporting list of used files.");
    }

    @Override
    protected void exportDbToCSV() {
        try {
            Export.db2Csv(Table.getNames());
            Gui.displayInformationDialog("Export of current database to directory\n'" + new File(Databases.getCurrent().getPath(), "Export") + "'\nsuccessfully finished.");
        }
        catch (Exception e) {
            e.printStackTrace();
            Gui.displayErrorDialog(e.getMessage());
        }
    }

    @Override
    protected void exportDbToMdb() {
        try {
            Export.db2Mdb();
            Gui.displayInformationDialog("Export of current database to mdb-file\n'" + new File(new File(Databases.getCurrent().getPath(), "Export"), String.valueOf(Databases.getCurrent().getName()) + ".mdb") + "'\nsuccessfully finished.");
        }
        catch (Exception e) {
            e.printStackTrace();
            Gui.displayErrorDialog(e.getMessage());
        }
    }

    private void writeUsedFilesToFile(File file, Set<String> filenames) {
        PrintWriter out = null;
        if (filenames.size() == 0) {
            return;
        }
        try {
            try {
                Const.log.info((Object)("  writing to '" + file + "'."));
                out = new PrintWriter(file);
                for (String filename : filenames) {
                    out.println(filename);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (out != null) {
                    out.close();
                }
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    @Override
    protected JPopupMenu createPlayGamePopupMenu() {
        JMenuItem menuItem;
        List<Emulator> emulators;
        JPopupMenu menu = new JPopupMenu();
        if (this.getSelectedGame() != null && (emulators = Emulators.getGameEmulators()) != null && emulators.size() > 0 && this.isSelectedItemOfTypeGame() && this.getSelectedGame().getGameFileExists()) {
            for (Emulator emulator : emulators) {
                menuItem = new JMenuItem();
                menuItem.setText(emulator.getName());
                menuItem.setActionCommand(Integer.toString(emulators.indexOf(emulator)));
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        String command = evt.getActionCommand();
                        if (command == null || command.isEmpty()) {
                            return;
                        }
                        Game game = GuiMethods.this.getSelectedGame();
                        if (game == null) {
                            return;
                        }
                        Emulator emulator = null;
                        try {
                            emulator = Emulators.getGameEmulators().get(Integer.parseInt(command));
                        }
                        catch (NumberFormatException numberFormatException) {}
                        if (emulator == null) {
                            return;
                        }
                        try {
                            game.play(emulator);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                });
                menu.add(menuItem);
            }
            menu.add(new JSeparator());
        }
        menuItem = new JMenuItem("<html><b>Manage</b></html>");
        menuItem.addActionListener(evt -> this.manageGameEmulators());
        menu.add(menuItem);
        return menu;
    }

    @Override
    protected JPopupMenu createPlayMusicPopupMenu() {
        JMenuItem menuItem;
        List<Emulator> emulators;
        JPopupMenu menu = new JPopupMenu();
        if (this.getSelectedItem() != null && (emulators = Emulators.getMusicEmulators()) != null && emulators.size() > 0 && (this.isSelectedItemOfTypeGame() && this.getSelectedGame().getMusicFileExists() || this.isSelectedItemOfTypeMusic() && this.getSelectedMusic().getFileExists())) {
            for (Emulator emulator : emulators) {
                menuItem = new JMenuItem();
                menuItem.setText(emulator.getName());
                menuItem.setActionCommand(Integer.toString(emulators.indexOf(emulator)));
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        String command = evt.getActionCommand();
                        if (command == null || command.isEmpty()) {
                            return;
                        }
                        Emulator emulator = null;
                        try {
                            emulator = Emulators.getMusicEmulators().get(Integer.parseInt(command));
                        }
                        catch (NumberFormatException numberFormatException) {}
                        if (emulator == null) {
                            return;
                        }
                        GuiMethods.this.playSelectedItemAsMusic(emulator);
                    }
                });
                menu.add(menuItem);
            }
            menu.add(new JSeparator());
        }
        menuItem = new JMenuItem("<html><b>Manage</b></html>");
        menuItem.addActionListener(evt -> this.manageMusicEmulators());
        menu.add(menuItem);
        return menu;
    }

    @Override
    protected JPopupMenu createExtrasButtonPopupMenu() {
        JMenuItem menuItem;
        List<Extra> extras;
        JPopupMenu menu = new JPopupMenu();
        Game game = this.getSelectedGame();
        if (game != null && (extras = game.getExtras()) != null && extras.size() > 0) {
            for (Extra extra : extras) {
                String filename;
                menuItem = new JMenuItem();
                String name = extra.getName();
                if (extra.isAdditional()) {
                    name = "+ " + name;
                }
                String string = filename = Paths.getExtraPath().find(new File(extra.getFilename())) != null ? Paths.getExtraPath().find(new File(extra.getFilename())).getPath() : "";
                if (!extra.isUrl() && filename.isEmpty()) {
                    name = String.valueOf(name) + " (!)";
                }
                menuItem.setText(name);
                menuItem.setActionCommand(Integer.toString(extra.getId()));
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        String command = evt.getActionCommand();
                        if (command != null && !command.isEmpty()) {
                            try {
                                int id = Integer.parseInt(command);
                                Extra extra = Db.getExtraById(id);
                                if (extra != null) {
                                    extra.play();
                                }
                            }
                            catch (IOException | NumberFormatException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                });
                menu.add(menuItem);
            }
            menu.add(new JSeparator());
        }
        menuItem = new JMenuItem("<html><b>Manage</b></html>");
        menuItem.addActionListener(evt -> this.editExtrasFile());
        menu.add(menuItem);
        return menu;
    }

    protected JPopupMenu createButtonsForExtrasPopupMenu(Extra extra) {
        JPopupMenu menu = new JPopupMenu();
        if (extra.isUrl()) {
            JMenuItem menuItem = new JMenuItem("Download to Additional Extras Directory");
            menuItem.addActionListener(evt -> {
                extra.download();
                Game game = Db.getGameById(extra.getGameId());
                game.syncAdditionalExtras(false);
                this.displaySelectedItem(true);
            });
            menu.setEnabled(DownloadTools.isDownloadableFiletype(extra.getFilename()));
            menu.add(menuItem);
            menu.add(new JSeparator());
            menuItem = new JMenuItem("Copy URL (mark for copying)");
            menuItem.addActionListener(evt -> {
                this.copyExtra = extra;
                this.status4.setText(extra.getName());
            });
            menu.add(menuItem);
            menuItem = new JMenuItem("Move URL to marked Game");
            menuItem.addActionListener(evt -> {
                int gameId = extra.getGameId();
                if (gameId > 0 && this.linkGame != null) {
                    Game srcGame = Db.getGameById(gameId);
                    Game dstGame = this.linkGame;
                    srcGame.getExtras().remove(extra);
                    extra.setGameId(dstGame.getId());
                    extra.setName(String.valueOf(dstGame.getName()) + " - " + extra.getCategory().getDir());
                    dstGame.getExtras().add(extra);
                    Db.saveOrUpdate(srcGame);
                    Db.saveOrUpdate(dstGame);
                    this.displaySelectedItem(true);
                }
            });
            menuItem.setEnabled(this.linkGame != null);
            menu.add(menuItem);
            menu.add(new JSeparator());
            menuItem = new JMenuItem("<html><i>Remove URL</i></html>");
            menuItem.addActionListener(evt -> {
                int gameId = extra.getGameId();
                if (gameId > 0) {
                    Game game = Db.getGameById(gameId);
                    extra.setGameId(0);
                    game.getExtras().remove(extra);
                    Db.delete(extra);
                    Db.saveOrUpdate(game);
                    this.displaySelectedItem(true);
                }
            });
            menu.add(menuItem);
            menu.add(new JSeparator());
            menuItem = new JMenuItem("<html><b>Properties</b></html>");
            menuItem.addActionListener(evt -> {
                int gameId = extra.getGameId();
                if (gameId > 0) {
                    Game game = Db.getGameById(gameId);
                    UrlDialog urlDialog = new UrlDialog(extra.getCategory().getDir(), extra.getFilename());
                    if (!(urlDialog.getCloseAction() != Const.CloseAction.OK || urlDialog.getCategoryDir().equals(extra.getCategory().getDir()) && urlDialog.getUrl().equals(extra.getFilename()))) {
                        extra.setName(String.valueOf(game.getName()) + " - " + urlDialog.getCategoryDir());
                        extra.reevaluateCategory();
                        extra.setFilename(urlDialog.getUrl());
                        Db.saveOrUpdate(game);
                        this.displaySelectedItem(true);
                    }
                    urlDialog.dispose();
                }
            });
            menu.add(menuItem);
        } else if (extra.isAdditional() && Plugins.existsExtractorForExtension(FileTools.getExtension(extra.getFilename()))) {
            JMenuItem menuItem = new JMenuItem("Extract to Additional Extras Directory");
            menuItem.addActionListener(evt -> {
                File extraFile = Paths.getExtraPath().findAndWarn(new File(extra.getFilename()));
                if (extraFile == null) {
                    return;
                }
                String extraFilename = extraFile.toString();
                if (Plugins.existsExtractorForExtension(FileTools.getExtension(extraFilename))) {
                    Const.log.info((Object)"extracting to temp");
                    Extractor extractor = Plugins.getExtractorForExtension(FileTools.getExtension(extraFilename));
                    try {
                        TempDir.cleanPath();
                        TempDir.getPath();
                        List<String> filenames = extractor.extractToDir(extraFilename, TempDir.getPath().getCanonicalPath());
                        File targetDir = new File(Paths.getAdditionalExtraPathId(extra.getGameId()), extra.getCategory().getDir());
                        for (String filename : filenames) {
                            File src = new File(filename);
                            File dst = new File(targetDir, src.getName());
                            Const.log.info((Object)("Moving '" + src + "' to '" + dst + "'"));
                            FileTools.copyFile(src, dst);
                        }
                        if (extra.isAdditional()) {
                            extraFile.delete();
                        }
                        Game game = Db.getGameById(extra.getGameId());
                        game.syncAdditionalExtras(false);
                        this.displaySelectedItem(true);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
            menu.add(menuItem);
        }
        return menu;
    }

    @Override
    protected JPopupMenu createSideButtonPanelPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        Game game = this.getSelectedGame();
        if (game != null) {
            JMenuItem menuItem = new JMenuItem("Add new URL");
            menuItem.addActionListener(evt -> {
                Game game1 = this.getSelectedGame();
                if (game1 != null) {
                    UrlDialog urlDialog = new UrlDialog();
                    if (urlDialog.getCloseAction() == Const.CloseAction.OK) {
                        Extra extra = new Extra();
                        extra.setGameId(game1.getId());
                        extra.setName(String.valueOf(game1.getName()) + " - " + urlDialog.getCategoryDir());
                        extra.setFilename(urlDialog.getUrl());
                        game1.getExtras().add(extra);
                        Db.saveOrUpdate(game1);
                        this.displaySelectedItem(true);
                    }
                    urlDialog.dispose();
                }
            });
            menu.add(menuItem);
            menu.add(new JSeparator());
            menuItem = new JMenuItem("Paste marked URL");
            menuItem.addActionListener(evt -> {
                Game game2 = this.getSelectedGame();
                if (game2 != null && this.copyExtra != null) {
                    new CopyOnWriteArrayList<Extra>(game2.getExtras()).stream().filter(existingExtra -> existingExtra.getFilename().equalsIgnoreCase(this.copyExtra.getFilename())).forEach(existingExtra -> {
                        existingExtra.setGameId(0);
                        game2.getExtras().remove(existingExtra);
                        Db.saveOrUpdate(game2);
                        Db.delete(existingExtra);
                    });
                    Extra extra = new Extra();
                    extra.setGameId(game2.getId());
                    extra.setName(String.valueOf(game2.getName()) + " - " + this.copyExtra.getCategory().getDir());
                    extra.setFilename(this.copyExtra.getFilename());
                    game2.getExtras().add(extra);
                    Db.saveOrUpdate(game2);
                    this.displaySelectedItem(true);
                }
            });
            menuItem.setEnabled(this.copyExtra != null);
            menu.add(menuItem);
            menuItem = new JMenuItem("Paste all URLs of selected Game");
            menuItem.addActionListener(evt -> {
                Game game3 = this.getSelectedGame();
                if (game3 != null && this.linkGame != null && game3.getId() != this.linkGame.getId()) {
                    this.linkGame.getExtras().stream().filter(linkExtra -> linkExtra.isUrl() && !linkExtra.getFilename().toLowerCase().startsWith("http://www.gamebase64.com/game.php")).forEach(linkExtra -> {
                        new CopyOnWriteArrayList<Extra>(game3.getExtras()).stream().filter(existingExtra -> existingExtra.isUrl() && existingExtra.getFilename().equalsIgnoreCase(linkExtra.getFilename())).forEach(existingExtra -> {
                            existingExtra.setGameId(0);
                            game3.getExtras().remove(existingExtra);
                            Db.saveOrUpdate(game3);
                            Db.delete(existingExtra);
                        });
                        Extra extra = new Extra();
                        extra.setGameId(game3.getId());
                        extra.setName(String.valueOf(game3.getName()) + " - " + linkExtra.getCategory().getDir());
                        extra.setFilename(linkExtra.getFilename());
                        game3.getExtras().add(extra);
                    });
                    Db.saveOrUpdate(game3);
                    this.displaySelectedItem(true);
                }
            });
            menuItem.setEnabled(this.linkGame != null && this.getSelectedGame() != null && this.linkGame.getId() != this.getSelectedGame().getId());
            menu.add(menuItem);
            menu.add(new JSeparator());
            menuItem = new JMenuItem("<html><i>Remove URLs identical to marked Game's URLs</i></html>");
            menuItem.addActionListener(evt -> {
                Game game4 = this.getSelectedGame();
                if (game4 != null && this.linkGame != null && game4.getId() != this.linkGame.getId()) {
                    new CopyOnWriteArrayList<Extra>(game4.getExtras()).forEach(extra -> this.linkGame.getExtras().stream().filter(linkExtra -> extra.isUrl() && linkExtra.isUrl() && extra.getFilename().equalsIgnoreCase(linkExtra.getFilename())).forEach(linkExtra -> {
                        extra.setGameId(0);
                        game4.getExtras().remove(extra);
                        Db.saveOrUpdate(game4);
                        Db.delete(extra);
                    }));
                    this.displaySelectedItem(true);
                }
            });
            menuItem.setEnabled(this.linkGame != null && this.getSelectedGame() != null && this.linkGame.getId() != this.getSelectedGame().getId());
            menu.add(menuItem);
            if (JGameBase.option_dangerous) {
                menuItem = new JMenuItem("<html><i>Remove ALL URLs</i></html>");
                menuItem.addActionListener(evt -> {
                    Game game5 = this.getSelectedGame();
                    if (game5 != null) {
                        new CopyOnWriteArrayList<Extra>(game5.getExtras()).stream().filter(extra -> extra.isUrl() && !extra.getFilename().toLowerCase().startsWith("http://www.gamebase64.com/game.php")).forEach(extra -> {
                            extra.setGameId(0);
                            game5.getExtras().remove(extra);
                            Db.saveOrUpdate(game5);
                            Db.delete(extra);
                        });
                        this.displaySelectedItem(true);
                    }
                });
                menu.add(menuItem);
            }
        }
        return menu;
    }

    protected synchronized void renameItem() {
        Item item = this.getSelectedItem();
        item.setName((String)JOptionPane.showInputDialog(this, "Name:", "Add Game...", -1, null, null, item.getName()));
        Db.saveOrUpdate(item);
    }

    @Override
    protected JPopupMenu createItemTablePopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Rename");
        menuItem.addActionListener(evt -> this.renameItem());
        menu.add(menuItem);
        menu.add(new JSeparator());
        menuItem = new JMenuItem("Edit " + (this.isSelectedItemOfTypeGame() ? "Game" : "Music") + " Info");
        menuItem.addActionListener(evt -> this.editGameMusicInfo_Current());
        menu.add(menuItem);
        if (this.isSelectedItemOfTypeGame()) {
            menuItem = new JMenuItem("Edit Version Info");
            menuItem.addActionListener(evt -> this.editVersionInfo_Current());
            menu.add(menuItem);
            menuItem = new JMenuItem("Edit Personal Info");
            menuItem.addActionListener(evt -> this.editPersonalInfo_Current());
            menu.add(menuItem);
            menu.add(new JSeparator());
            menuItem = new JMenuItem("Select Game File");
            menuItem.addActionListener(evt -> this.editGameFile());
            menu.add(menuItem);
        }
        menuItem = new JMenuItem("Select Music File");
        menuItem.addActionListener(evt -> this.editMusicFile());
        menu.add(menuItem);
        if (this.isSelectedItemOfTypeGame()) {
            menu.add(new JSeparator());
            menuItem = new JMenuItem("Manage Screenshots");
            menuItem.addActionListener(evt -> this.editScreenshotsFile());
            menu.add(menuItem);
            menuItem = new JMenuItem("Extras");
            menuItem.addActionListener(evt -> this.editExtrasFile());
            menu.add(menuItem);
        }
        return menu;
    }

    public void updateEditRemoveViewEnabled() {
        ((ItemTableModel)this.itemTable.getModel()).updateEditRemoveViewEnabled();
    }

    @Override
    protected void removeSelectedItem() {
        Item item = this.getSelectedItem();
        if (item != null) {
            Db.delete(item);
            ((ItemTableModel)this.itemTable.getModel()).reloadView();
        }
    }

    @Override
    protected void removeAllItems() {
        if (JOptionPane.showConfirmDialog(this, "This will DELETE all games and music in the current view!\nReally do it (may take a long time)?", "jGameBase", 0) == 0) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            ItemView view = (ItemView)this.filterViewCombobox.getSelectedItem();
            Db.deleteAll(view.getData());
            this.setCursor(Cursor.getPredefinedCursor(0));
            ((ItemTableModel)this.itemTable.getModel()).reloadView();
        }
    }

    @Override
    protected void addGameFile() {
        GameChooserDialog dialog = new GameChooserDialog();
        if (dialog.getCloseAction() == Const.CloseAction.OK) {
            String suggestedName = dialog.getGameName().trim();
            if (!suggestedName.isEmpty()) {
                suggestedName = suggestedName.replaceAll("^\\S*\\s*", "");
                suggestedName = suggestedName.replaceAll("\\s*\\S*$", "");
                suggestedName = suggestedName.replaceAll("\"", "");
                suggestedName = StringTools.capitalize(suggestedName);
            } else {
                suggestedName = dialog.getGameFileToRun();
            }
            String name = (String)JOptionPane.showInputDialog(this, "Name:", "Add Game...", -1, null, null, suggestedName);
            Game game = new Game(name, dialog.getGameFilename(), dialog.getGameFileToRun(), dialog.getGameFilenameIndex());
            Db.saveOrUpdate(game);
            ((ItemTableModel)this.itemTable.getModel()).reloadView();
        }
    }

    @Override
    protected void editGameFile() {
        GameChooserDialog dialog;
        Game game = this.getSelectedGame();
        if (game != null && (dialog = new GameChooserDialog(game)).getCloseAction() == Const.CloseAction.OK) {
            game.setFilename(dialog.getGameFilename());
            game.setFileToRun(dialog.getGameFileToRun());
            game.setFilenameIndex(dialog.getGameFilenameIndex());
            Db.saveOrUpdate(game);
            this.updateItemTable();
        }
    }

    @Override
    protected void addMusicFile() {
        MusicChooserDialog dialog = new MusicChooserDialog();
        if (dialog.getCloseAction() == Const.CloseAction.OK) {
            String name = (String)JOptionPane.showInputDialog(this, "Name:", "Add Music...", -1, null, null, "");
            Music music = new Music(name, dialog.getFilename());
            Db.saveOrUpdate(music);
            ((ItemTableModel)this.itemTable.getModel()).reloadView();
        }
    }

    @Override
    protected void editMusicFile() {
        Music music;
        MusicChooserDialog dialog;
        Item item = this.getSelectedItem();
        if (item == null) {
            return;
        }
        if (item instanceof Game) {
            Game game = (Game)item;
            MusicChooserDialog dialog2 = new MusicChooserDialog(game);
            if (dialog2.getCloseAction() == Const.CloseAction.OK) {
                game.setMusicFilename(dialog2.getFilename());
                Db.saveOrUpdate(game);
                this.updateItemTable();
            }
        } else if (item instanceof Music && (dialog = new MusicChooserDialog(music = (Music)item)).getCloseAction() == Const.CloseAction.OK) {
            music.setFilename(dialog.getFilename());
            Db.saveOrUpdate(music);
            this.updateItemTable();
        }
    }

    @Override
    protected void editScreenshotsFile() {
        ScreenshotChooserDialog dialog;
        Game game = this.getSelectedGame();
        if (game != null && (dialog = new ScreenshotChooserDialog(game)).getCloseAction() == Const.CloseAction.OK) {
            game.setScreenshotFilename(dialog.getFilename());
            Db.saveOrUpdate(game);
            this.updateItemTable();
        }
    }

    @Override
    protected void editExtrasFile() {
        if (this.getSelectedGame() == null) {
            return;
        }
        Game game = this.getSelectedGame();
        ExtrasDialog extrasDialog = new ExtrasDialog(game.getExtras(), game.getName());
        if (extrasDialog.getCloseAction() == Const.CloseAction.OK) {
            game.getExtras().stream().filter(extra -> !extrasDialog.getExtras().contains(extra)).forEach(extra -> {
                Const.log.info((Object)("deleting Extra " + extra.getName()));
                extra.setGameId(0);
                Db.delete(extra);
            });
            game.setExtras(extrasDialog.getExtras());
            Db.saveOrUpdate(game);
        }
        extrasDialog.dispose();
    }

    @Override
    protected void editAdditionalExtrasFile() {
        Game game = this.getSelectedGame();
        if (game != null) {
            File dir = Paths.getAdditionalExtraPathId(game.getId());
            Paths.createAdditionalExtraDirectories(game.getId(), game.getName());
            SystemTools.open(dir.toURI());
            game.syncAdditionalExtras(false);
            this.displaySelectedItem(true);
        }
    }

    @Override
    protected void syncAdditionalExtras() {
        int answer;
        ItemTableModel data = (ItemTableModel)this.itemTable.getModel();
        if (this.filterViewCombobox.getSelectedIndex() != 0 && (answer = JOptionPane.showConfirmDialog(this, "Do you want me to change to the '<All Games>' view so that the additional extras of all games will be synchronized?\nOtherwise only the additional extras of the games in the current view will be synchronized.", "jGameBase", 0)) == 0) {
            this.filterViewCombobox.setSelectedIndex(0);
            data.setView((ItemView)this.views.get(0));
        }
        Iterator<Item> iter = data.iterator();
        while (iter.hasNext()) {
            Item item = iter.next();
            if (!(item instanceof Game)) continue;
            Game game = (Game)item;
            game.syncAdditionalExtras(true);
        }
        Extra.processQueuedForDeletion();
        this.displaySelectedItem(true);
        data.saveOrUpdateView();
        Db.reorganizeExtras();
        Gui.displayInformationDialog("The additional extras for this view have been synchronized.");
    }

    private void removeDuplicateUrlExtras(Game game) {
        CopyOnWriteArrayList urlExtras = new CopyOnWriteArrayList();
        urlExtras.addAll(game.getExtras().stream().filter(Extra::isUrl).collect(Collectors.toList()));
        try {
            for (Extra extraA : urlExtras) {
                URI urlA = new URI(extraA.getFilename());
                for (Extra extraB : urlExtras) {
                    URI urlB = new URI(extraB.getFilename());
                    if (extraA == extraB || !urlA.equals(urlB) || extraA.getGameId() != extraB.getGameId() || extraA.getGameId() == 0) continue;
                    extraB.setGameId(0);
                    game.getExtras().remove(extraB);
                    Db.delete(extraB);
                    Db.saveOrUpdate(game);
                }
            }
        }
        catch (Exception exception) {}
    }

    private Extra newUrlExtra(int gameId, String name, String filename) {
        Extra extra = new Extra();
        extra.setGameId(gameId);
        extra.setName(name);
        extra.setFilename(filename);
        return extra;
    }

    private void addUrlsFromCsv() {
        ItemTableModel data = (ItemTableModel)this.itemTable.getModel();
        List<String[]> lines = this.loadUrlsFromCsv();
        MultiValueMap urls = new MultiValueMap();
        lines.forEach(line -> {
            try {
                urls.put((Object)Integer.valueOf(line[0]), line);
            }
            catch (NumberFormatException numberFormatException) {
                Const.log.warn((Object)("Could not convert '" + line[0] + "' to valid GameID."));
            }
        });
        ArrayList<Game> gamesToUpdate = new ArrayList<Game>();
        Iterator<Item> iter = data.iterator();
        while (iter.hasNext()) {
            Game game;
            Item item = iter.next();
            if (!(item instanceof Game) || !urls.containsKey((Object)(game = (Game)item).getId())) continue;
            gamesToUpdate.add(game);
            Collection extras = urls.getCollection((Object)game.getId());
            extras.forEach(rawExtra -> {
                Const.log.info((Object)("Adding url extra " + rawExtra[2]));
                ArrayList<Extra> newExtras = new ArrayList<Extra>();
                boolean existingUpdated = false;
                for (Extra existingExtra : game.getExtras()) {
                    if (existingExtra.isUrl() && existingExtra.getFilename().equals(rawExtra[2])) {
                        if (!existingUpdated) {
                            existingUpdated = true;
                            existingExtra.setName(String.valueOf(game.getName()) + " - " + rawExtra[1]);
                            existingExtra.setFilename(rawExtra[2]);
                            existingExtra.reevaluateCategory();
                            newExtras.add(existingExtra);
                            continue;
                        }
                        existingExtra.setGameId(0);
                        Extra.enqueueForDeletion(existingExtra);
                        continue;
                    }
                    newExtras.add(existingExtra);
                }
                if (!existingUpdated) {
                    newExtras.add(this.newUrlExtra(game.getId(), String.valueOf(game.getName()) + " - " + rawExtra[1], rawExtra[2]));
                }
                game.setExtras(newExtras);
            });
        }
        Const.log.info((Object)"Removing deleted extras");
        Extra.processQueuedForDeletion();
        Const.log.info((Object)"Writing to database");
        Db.saveOrUpdateAll(gamesToUpdate);
        Const.log.info((Object)"Finished importing URLs from CSV");
    }

    private List<String[]> loadUrlsFromCsv() {
        File csvFilename = new File(Databases.getCurrent().getPath(), "url.csv");
        ArrayList<String[]> lines = new ArrayList();
        Const.log.info((Object)("Loading URLs from file '" + csvFilename + "'..."));
        try {
            CSVReader reader = new CSVReader((Reader)new FileReader(csvFilename), ',', '\"', '\u0010');
            lines = reader.readAll();
        }
        catch (IOException iOException) {
            Const.log.warn((Object)("Problem reading file '" + csvFilename + "'!"));
        }
        return lines;
    }

    private void saveUrlsToCsv() {
        ArrayList<String[]> urls = new ArrayList<String[]>();
        List<Extra> extras = Db.getExtras();
        extras.stream().filter(Extra::isUrl).forEach(extra -> {
            Const.log.info((Object)("export URL '" + extra.getFilename() + "'."));
            String[] url = new String[]{Integer.toString(extra.getGameId()), extra.getCategory().getDir(), extra.getFilename()};
            urls.add(url);
        });
        this.saveUrlListToCsv(urls, false);
    }

    private void saveUrlListToCsv(List<String[]> urls, boolean append) {
        block15: {
            File file = new File(Databases.getCurrent().getPath(), "url.csv");
            CSVWriter writer = null;
            try {
                try {
                    writer = new CSVWriter((Writer)new FileWriter(file, append), ',', '\"', '\u0010');
                    for (String[] line : urls) {
                        writer.writeNext(line);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    protected void importURLsFromCSV() {
        try {
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.addUrlsFromCsv();
                this.displaySelectedItem(true);
                Db.reorganizeExtras();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    @Override
    protected void exportURLsToCSV() {
        try {
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.saveUrlsToCsv();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    @Override
    protected void matchURLsFromCSV() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileFilter(this.csvFileFilter);
        try {
            try {
                if (fileChooser.showOpenDialog(null) == 0) {
                    File file = fileChooser.getSelectedFile();
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.matchUrlsByName(file);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void matchUrlsByName(File csvFile) {
        block28: {
            if (csvFile == null || !csvFile.exists()) {
                Const.log.error((Object)("File with new URLs '" + csvFile + "' not found; nothing to do."));
                return;
            }
            List lines = new ArrayList();
            List<String[]> found = new ArrayList<String[]>();
            ArrayList<String[]> notFound = new ArrayList<String[]>();
            int notFoundCount = 0;
            Const.log.info((Object)("Matching URLs from file '" + csvFile + "'..."));
            try {
                CSVReader reader = new CSVReader((Reader)new FileReader(csvFile), ',', '\"', '\u0010');
                lines = reader.readAll();
            }
            catch (IOException iOException) {
                Const.log.warn((Object)("Problem reading file '" + csvFile + "'!"));
            }
            if (lines.size() == 0) {
                Const.log.info((Object)("File with new URLs '" + csvFile + "' empty; nothing to do."));
                return;
            }
            ItemTableModel data = (ItemTableModel)this.itemTable.getModel();
            ArrayList<AbstractMap.SimpleEntry<String, Game>> Games = new ArrayList<AbstractMap.SimpleEntry<String, Game>>();
            ArrayList<AbstractMap.SimpleEntry<String, Game>> GamesNoSpace = new ArrayList<AbstractMap.SimpleEntry<String, Game>>();
            Iterator<Item> iter = data.iterator();
            while (iter.hasNext()) {
                Item item = iter.next();
                if (!(item instanceof Game)) continue;
                Game game = (Game)item;
                AbstractMap.SimpleEntry<String, Game> Entry2 = new AbstractMap.SimpleEntry<String, Game>(StringTools.simplifyForMatching(game.getName()), game);
                Games.add(Entry2);
                Entry2 = new AbstractMap.SimpleEntry<String, Game>(StringTools.simplifyForMatching(game.getName()).replaceAll("\\s", ""), game);
                GamesNoSpace.add(Entry2);
            }
            for (String[] line : lines) {
                double match;
                String simplified = StringTools.simplifyForMatching(line[0]);
                Const.log.info((Object)("Trying to match '" + line[0] + "' as '" + simplified + "'..."));
                double bestMatch = 0.0;
                Game bestGame = null;
                boolean isFound = false;
                for (AbstractMap.SimpleEntry simpleEntry : Games) {
                    match = StringTools.getStringSimilarity(simplified, (String)simpleEntry.getKey());
                    if (match > bestMatch) {
                        bestMatch = match;
                        bestGame = (Game)simpleEntry.getValue();
                    }
                    if (match != 1.0) continue;
                    Const.log.info((Object)("'" + line[0] + "' matches '" + ((Game)simpleEntry.getValue()).getName() + "'."));
                    found = this.addUrlFromCsv(found, (Game)simpleEntry.getValue(), line);
                    isFound = true;
                }
                if (!isFound) {
                    for (AbstractMap.SimpleEntry simpleEntry : Games) {
                        match = StringTools.getStringSimilarity(simplified, (String)simpleEntry.getKey());
                        if (!(match > 0.865)) continue;
                        Const.log.info((Object)("'" + line[0] + "' matches '" + ((Game)simpleEntry.getValue()).getName() + "' with " + match + "."));
                        found = this.addUrlFromCsv(found, (Game)simpleEntry.getValue(), line);
                        isFound = true;
                    }
                }
                if (!isFound) {
                    for (AbstractMap.SimpleEntry simpleEntry : GamesNoSpace) {
                        String simplifiedNoSpace = simplified.replaceAll("\\s", "");
                        int len = Math.min(simplifiedNoSpace.length(), ((String)simpleEntry.getKey()).length());
                        String name = StringTools.convertNumbers_AllToArabic(line[0]);
                        String match2 = StringTools.convertNumbers_AllToArabic(((Game)simpleEntry.getValue()).getName());
                        if (len < 7 || name.matches("^.*\\d+.*$") || match2.matches("^.*\\d+.*$") || !simplifiedNoSpace.substring(0, len).equalsIgnoreCase(((String)simpleEntry.getKey()).substring(0, len))) continue;
                        Const.log.info((Object)("Beginning of '" + line[0] + "' matches beginning of '" + ((Game)simpleEntry.getValue()).getName() + "' without whitespace."));
                        found = this.addUrlFromCsv(found, (Game)simpleEntry.getValue(), line);
                        isFound = true;
                    }
                }
                if (isFound) continue;
                if (bestMatch >= 0.8) {
                    Const.log.info((Object)("Best match for '" + simplified + "' found '" + bestGame.getName() + "' with " + bestMatch + "."));
                    found = this.addUrlFromCsv(found, bestGame, line);
                    continue;
                }
                Const.log.info((Object)("NO match for '" + simplified + "' found."));
                notFound.add(line);
                ++notFoundCount;
            }
            Const.log.info((Object)("MATCHED " + lines.size()));
            Const.log.info((Object)("  FOUND:    " + (lines.size() - notFoundCount)));
            Const.log.info((Object)("  NOT FOUND:" + notFoundCount));
            this.saveUrlListToCsv(found, true);
            CSVWriter writer = null;
            File file = new File(Databases.getCurrent().getPath(), "url_notfound.csv");
            try {
                try {
                    writer = new CSVWriter((Writer)new FileWriter(file, true), ',', '\"', '\u0010');
                    for (String[] line : notFound) {
                        writer.writeNext(line);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block28;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private List<String[]> addUrlFromCsv(List<String[]> urls, Game game, String[] newUrl) {
        if (newUrl.length < 2 || newUrl.length > 3) {
            Const.log.warn((Object)("Could not add entry '" + Arrays.toString(newUrl) + "' to url csv file."));
            return urls;
        }
        String[] url = new String[3];
        url[0] = Integer.toString(game.getId());
        if (newUrl.length == 2) {
            url[1] = "Misc";
            url[2] = newUrl[1];
        } else if (newUrl.length == 3) {
            url[1] = newUrl[1];
            url[2] = newUrl[2];
        }
        urls.add(url);
        return urls;
    }

    @Override
    protected void help() {
        SystemTools.open(Const.URI_DOCUMENTATION);
    }

    @Override
    protected void bugtracker() {
        SystemTools.open(Const.URI_BUGTRACKING);
    }

    @Override
    protected void findInList() {
        this.find = JOptionPane.showInputDialog(this, "Text to find:", "Find in List", -1);
        if (this.find == null) {
            this.find = "";
            return;
        }
        this.find = this.find.toLowerCase().trim();
        if (this.find.isEmpty()) {
            return;
        }
        ItemTableModel data = (ItemTableModel)this.itemTable.getModel();
        if (data.getRowCount() < 1) {
            return;
        }
        data.setSelectedRow(0);
        this.findNext();
    }

    @Override
    protected void findNext() {
        if (this.find.isEmpty()) {
            this.findInList();
        }
        if (this.getSelectedItem() == null) {
            return;
        }
        int startRow = this.itemTable.getSelectedRow();
        ItemTableModel data = (ItemTableModel)this.itemTable.getModel();
        boolean found = false;
        int i = startRow + 1;
        while (i < data.getRowCount()) {
            String col1 = ((Item)data.getValueAt(i, 0)).getName().toLowerCase();
            String col2 = ((String)data.getValueAt(i, 1)).toLowerCase();
            if (col1.contains(this.find) || col2.contains(this.find)) {
                found = true;
                break;
            }
            ++i;
        }
        if (found) {
            data.setSelectedRow(i);
            this.updateItemTable();
        } else if (i == data.getRowCount()) {
            if (startRow == 0) {
                Gui.displayInformationDialog("No matches found!");
            } else {
                data.setSelectedRow(0);
                this.findNext();
            }
        }
    }

    @Override
    protected void markGameForLinking() {
        Game game = this.getSelectedGame();
        if (game == null) {
            return;
        }
        this.linkGame = game;
        this.status3.setText(String.valueOf(game.getStringId()) + ": " + game.getName());
        this.displaySelectedItem(true);
    }

    @Override
    protected void setGameLink() {
        Game selectedGame = this.getSelectedGame();
        if (selectedGame == null || this.linkGame == null || selectedGame.getId() == this.linkGame.getId()) {
            return;
        }
        new SetGameLinkDialog(selectedGame, this.linkGame);
        this.updateItemTable();
    }

    @Override
    protected void clearGameLink() {
        Game game = this.getSelectedGame();
        if (game == null) {
            return;
        }
        new ClearGameLinkDialog(game);
        this.updateItemTable();
    }

    @Override
    protected void options() {
        new OptionsDialog();
    }

    @Override
    protected void verifyAvailableFiles() {
        new VerifyAvailableFilesDialog();
        this.clearAllViewCaches();
        this.reloadCurrentView();
    }

    protected void clearAllViewCaches() {
        this.views.forEach(ItemView::clearCache);
    }

    public void reloadCurrentView() {
        ItemView view = (ItemView)this.filterViewCombobox.getSelectedItem();
        ((ItemTableModel)this.itemTable.getModel()).setView(view);
        ((ItemTableModel)this.itemTable.getModel()).fireTableDataChanged();
        this.filterViewCombobox.setAction(this.filterViewCombobox.getAction());
    }

    public int getSidebarWidth() {
        return this.mainPane.getSize().width - this.mainPane.getDividerLocation() - this.mainPane.getInsets().right - this.mainPane.getDividerSize();
    }

    @Override
    protected void setSidebarWidth(int size) {
        this.mainPane.setDividerLocation(this.mainPane.getSize().width - this.mainPane.getInsets().right - this.mainPane.getDividerSize() - size);
        Databases.getCurrent().getPreferences().set("sidebar_width", size);
    }

    public void initAfterVisible() {
        this.setSidebarWidth(Databases.getCurrent().getPreferences().getInt("sidebar_width"));
        this.sidePanel_HSplitPane.setDividerLocation(Databases.getCurrent().getPreferences().getInt("sidebar_h_divider"));
        this.sidePanel_VSplitPane.setDividerLocation(Databases.getCurrent().getPreferences().getInt("sidebar_v_divider"));
        this.selectItem(Databases.getCurrent().getPreferences().get("selected_item"), false);
    }

    @Override
    protected void playSelectedItemAsMusic(Emulator emulator) {
        this.stopMusic();
        Item item = this.getSelectedItem();
        boolean playing = false;
        if (item instanceof Game) {
            Game game = (Game)item;
            Music music = new Music();
            music.setName(game.getName());
            music.setFilename(game.getMusicFilename());
            music.play(emulator);
            playing = true;
        }
        if (item instanceof Music) {
            Music music = (Music)item;
            this.addToRecent(item);
            music.play(emulator);
            this.filterStopMusicButton.setEnabled(Emulators.isMusicRunning());
            playing = true;
        }
        if (playing) {
            this.filterStopMusicButton.setEnabled(true);
            checkStopMusicButtonStatus = new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    while (Emulators.isMusicRunning()) {
                        Thread.sleep(100L);
                    }
                    return null;
                }

                @Override
                protected void done() {
                    GuiMethods.this.filterStopMusicButton.setEnabled(Emulators.isMusicRunning());
                }
            };
            checkStopMusicButtonStatus.execute();
        }
    }

    @Override
    protected void stopMusic() {
        Emulators.stopRunningMusic();
        this.filterStopMusicButton.setEnabled(Emulators.isMusicRunning());
        if (checkStopMusicButtonStatus != null) {
            checkStopMusicButtonStatus.cancel(true);
        }
    }

    @Override
    public void unzipDatabase(File file) {
        if (file == null) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileFilter(this.zipFileFilter);
            if (fileChooser.showOpenDialog(null) == 0) {
                file = fileChooser.getSelectedFile();
            }
        }
        try {
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    @Override
    protected void downloadJDB() {
        Gui.displayWarningDialog("Download jGameBase databases and extract them into a subdirectory under '" + Const.GBDIR_RW + "'.\n" + "Then start jGamebase again.");
        SystemTools.open(Const.URI_DOWNLOAD_JDB);
    }

    @Override
    protected void downloadDB() {
        Gui.displayWarningDialog("Download GameBase databases and extract them into a subdirectory under '" + Const.GBDIR_RW + "'.\n" + "Then start jGamebase again.\n\n" + "You will either need to get a matching database overlay or adjust the emulator configuration and scripts.");
        SystemTools.open(Const.URI_DOWNLOAD_DB);
    }

    @Override
    protected void importGames() {
        JFileChooser fileChooser = new JFileChooser();
        List<Object> files = new ArrayList();
        FileExtensions diskExts = new FileExtensions(Plugins.getSupportedDiskInfoExtension());
        FileExtensions gameExts = Emulators.getSupportedGameExtensions();
        FileExtensions extractorExts = new FileExtensions(Plugins.getSupportedExtractorExtension());
        FileExtensions allExts = new FileExtensions();
        allExts.add(diskExts);
        allExts.add(gameExts);
        allExts.add(extractorExts);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setFileFilter(new FileNameExtensionFilter("All supported files (" + allExts + ")", allExts.toArray(new String[0])));
        fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Packed files (" + extractorExts + ")", extractorExts.toArray(new String[0])));
        fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Image files (" + diskExts + ")", diskExts.toArray(new String[0])));
        fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Game and image files (" + gameExts + ")", gameExts.toArray(new String[0])));
        fileChooser.setMultiSelectionEnabled(true);
        if (fileChooser.showOpenDialog(null) == 0) {
            files = Arrays.asList(fileChooser.getSelectedFiles());
            files.forEach(file -> {
                String filename = file.getName();
                String ext = FileTools.getExtension(filename);
                if (diskExts.matches((File)file)) {
                    Const.log.info((Object)("IMAGE " + file));
                    String relativePath = Paths.getGamePath().getRelativePathFor((File)file).getPath();
                    DiskInfo diskInfo = Plugins.getDiskInfoForExtension(ext);
                    try {
                        diskInfo.load(file.getAbsolutePath());
                        int entryCount = diskInfo.getDirectory().length;
                        int i = 0;
                        while (i < entryCount) {
                            String name = StringTools.capitalize(diskInfo.getFilenameAt(i));
                            if (name.isEmpty()) {
                                name = String.valueOf(file.getName()) + "_" + i;
                            }
                            Const.log.info((Object)(String.valueOf(i) + ": " + name));
                            Game game = new Game(name, relativePath, "", i);
                            Db.saveOrUpdate(game);
                            ++i;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else if (gameExts.matches((File)file)) {
                    String name = StringTools.capitalize(FileTools.removeExtension(file.getName()));
                    Const.log.info((Object)("GAME " + file + " - " + name));
                    Game game = new Game(name, file.getAbsolutePath(), "", -1);
                } else if (extractorExts.matches((File)file)) {
                    String name = StringTools.capitalize(FileTools.removeExtension(file.getName()));
                    Const.log.info((Object)("PACKED " + file + " - " + name));
                    Game game = new Game(name, file.getAbsolutePath(), "", -1);
                }
            });
        }
    }

    @Override
    protected void manageMusicEmulators() {
        ManageEmulatorsDialog musicEmulatorsDialog = new ManageEmulatorsDialog(Emulators.getMusicEmulators(), "Music");
        if (musicEmulatorsDialog.getCloseAction() == Const.CloseAction.OK) {
            Emulators.setMusicEmulators(musicEmulatorsDialog.getEmulators());
        }
        Emulators.writeToIniFile();
    }

    @Override
    protected void manageGameEmulators() {
        ManageEmulatorsDialog gameEmulatorsDialog = new ManageEmulatorsDialog(Emulators.getGameEmulators(), "Game");
        if (gameEmulatorsDialog.getCloseAction() == Const.CloseAction.OK) {
            Emulators.setGameEmulators(gameEmulatorsDialog.getEmulators());
        }
        Emulators.writeToIniFile();
    }
}

